chrome.runtime.onMessage.addListener(async (request, sender, sendResponse) => {
  if (request.command === "transferFile") {
    try {
      let content_src = "";
      if (document.querySelector("iframe") !== null) {
        content_src = document.querySelector("iframe").src;
      } else if (document.querySelector("object") !== null) {
        content_src = document.querySelector("object").data;
      } else {
        alert("failed to find transfer file sorce in this page");
      }
      const response = await fetch(content_src);
      const blob = await response.blob();
      const formData = new FormData();
      formData.append("file", blob);
      //convert to base64
      const reader = new FileReader();
      reader.readAsDataURL(blob);
      const uploadResponse = await fetch(
        "https://qrcode-file.ryokuryu.com/api/send",
        {
          //const uploadResponse = await fetch("https://ivz45khvlm4bojy6pzlgdw47pa0iovjc.lambda-url.ap-northeast-1.on.aws/", {
          //const uploadResponse = await fetch("http://localhost:8787/", {
          method: "POST",
          body: blob,
          headers: {
            "content-type": response.headers.get("content-type"),
          },
        }
      );
      const data = await uploadResponse.json();
      if (data.file_url_qr) {
        window.open(data.file_url_qr, "_blank");
      }
    } catch (error) {
      console.error("Error:", error);
      alert(
        "failed to transfer file\n error message: " +
          error.message +
          "\n please try again later"
      );
    }
  }
  else if(request.command === "update_available_alert_qrcode_file"){
    alert("please update available QRcode file extention");
  }
});
