chrome.runtime.onInstalled.addListener(() => {
    chrome.contextMenus.create({
        id: "transferFile",
        title: "Transfer file via QRcode",
        contexts: ["all"]
    });
});

chrome.contextMenus.onClicked.addListener(async(info, tab) => {
    if (info.menuItemId === "transferFile") {
        chrome.tabs.sendMessage(tab.id, { command: "transferFile" });
        //update check
        const manifest_version = chrome.runtime.getManifest().version;
        const latest_manifest = (await(await fetch("https://qrcode-file.ryokuryu.com/extension/chrome/manifest.json")).json())["version"];
        if (manifest_version !== latest_manifest) {
            chrome.tabs.sendMessage(tab.id, { command: "update_available_alert_qrcode_file" });
        }
    }
});
